/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.data.gen;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import knightminer.simplytea.block.TeaTrunkBlock;
import knightminer.simplytea.core.Registration;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.conditions.TableBonus;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockLootTableGenerator
extends BlockLootTables {
    private final ResourceLocation LEAVES_ID = new ResourceLocation("simplytea", "blocks/tea_leaves");

    @Nonnull
    protected Iterable<Block> getKnownBlocks() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> "simplytea".equals(Objects.requireNonNull(block.getRegistryName()).func_110624_b())).collect(Collectors.toList());
    }

    public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
        this.addTables();
        HashSet set = Sets.newHashSet();
        for (Block block : this.getKnownBlocks()) {
            ResourceLocation name = block.func_220068_i();
            if (name == LootTables.field_186419_a || !set.add(name)) continue;
            LootTable.Builder builder = (LootTable.Builder)this.field_218581_i.remove(name);
            if (builder == null) {
                throw new IllegalStateException(String.format("Missing loottable '%s' for '%s'", name, block.getRegistryName()));
            }
            consumer.accept(name, builder);
        }
        LootTable.Builder leavesBuilder = (LootTable.Builder)this.field_218581_i.remove(this.LEAVES_ID);
        if (leavesBuilder == null) {
            throw new IllegalStateException(String.format("Missing loottable '%s' for '%s'", this.LEAVES_ID, Registration.tea_tree.getRegistryName()));
        }
        consumer.accept(this.LEAVES_ID, leavesBuilder);
        if (!this.field_218581_i.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + this.field_218581_i.keySet());
        }
    }

    protected void addTables() {
        this.func_218492_c(Registration.tea_fence);
        this.func_218492_c(Registration.tea_fence_gate);
        this.func_218492_c((Block)Registration.tea_sapling);
        this.func_218547_a(Registration.potted_tea_sapling);
        this.field_218581_i.put(this.LEAVES_ID, LootTable.func_216119_b().func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()).func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Registration.tea_leaf))).func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Registration.tea_leaf).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.55f, (int)2)))).func_216040_a(LootPool.func_216096_a().func_212840_b_(SurvivesExplosion.func_215968_b()).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f})).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Registration.tea_sapling))));
        this.func_218522_a(Registration.tea_trunk, block -> LootTable.func_216119_b().func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()).func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Registration.tea_stick))).func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Registration.tea_stick).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.55f, (int)2)))).func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227195_a_((Property)TeaTrunkBlock.CLIPPED, false))).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)this.LEAVES_ID))));
    }
}

